import React from "react";

import { Metadata } from "next";
import { Inter } from "next/font/google";
import { generateMetadataObject } from "@/lib/shared/metadata";

import { cn } from "@/lib/utils";
import { ViewTransitions } from "next-view-transitions";
import fetchContentType from "@/lib/strapi/fetchContentType";
import Navbar from "@/components/navbar";
import Footer from "@/components/footer";

const inter = Inter({
	subsets: ["latin"],
	display: "swap",
	weight: ["400", "500", "600", "700", "800", "900"],
});

// Default Global SEO for pages without them
export async function generateMetadata({
	params,
}: {
	params: { locale: string; slug: string };
}): Promise<Metadata> {
	const pageData = await fetchContentType(
		"global",
		`&filters[locale][$eq]=${params.locale}&populate=seo.metaImage`,
		true
	);

	const seo = pageData?.seo;
	const metadata = generateMetadataObject(seo);
	return metadata;
}

export default async function LocaleLayout({
	children,
	params: { locale },
}: {
	children: React.ReactNode;
	params: { locale: string };
}) {
	const pageData = await fetchContentType(
		"global",
		`filters[locale][$eq]=${locale}`,
		true
	);
	return (
		<html lang={locale}>
			<ViewTransitions>
				<body
					className={cn(
						inter.className,
						"bg-charcoal antialiased h-full w-full"
					)}
				>
					{pageData?.navbar && <Navbar {...pageData?.navbar} />}
					{children}
					{pageData?.footer && <Footer {...pageData?.footer} />}
				</body>
			</ViewTransitions>
		</html>
	);
}
